/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.internal;

import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.internal.Cleaner$Cleaner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import melotr.ConfigChangedHandler;

public class ReflectionUtils {
    private static final Method METHOD_HANDLES_LOOKUP_IN;
    private static final Method METHOD_TYPE;
    private static final Method METHOD_IS_DEFAULT;
    private static final Method METHOD_HANDLES_INVOKE_WITH_ARGUMENTS;
    private static final Logger LOG;
    private static final Method METHOD_HANDLES_PRIVATE_LOOKUP_IN;
    private static final Method METHOD_HANDLES_LOOKUP;
    private static Constructor CONSTRUCTOR_LOOKUP_CLASS;
    private static final Method METHOD_HANDLES_BIND_TO;
    private static final Method METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL;
    private static final Method METHOD_HANDLES_LOOKUP_FIND_SPECIAL;

    private static /* synthetic */ Method lookupMethod(Class clazz, String methodName, Class ... arguments) {
        if (clazz == null) {
            LOG.log(Level.FINE, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u6473\uf48b\u6ac0\u5b2a\u2304\u659f\u3c45\u9dbe\uab1c\ua216\u328f\u2d9a\u7471\u7d45\u4ccd\ua2d2\u1d7f\u62b5\u56e3\u5c1a\u5585\u0b8a\ub615\ubadb\u07f9\u38cf\u6ae1\u9294\u92ba\u70c5\uaa3eH\u70af\uf3e2\u6925\u3d0e\ud787")), new Object[]{clazz, methodName, Arrays.toString(arguments)});
            return null;
        }
        try {
            return clazz.getMethod(methodName, arguments);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u644f\uf4cb\u6afc\u5b6a\u2338\u65df\u3c79\u9dfe\uab20\ua256\u32b3\u2dda\u744d\u7d05\u4cf1\ua292\u1d43\u62f5\u56df\u5c5a\u55b9\u0bca\ub629\uba9b\u07c5\u388f\u6add\u92d4\u9286\u7085\uaa02\b\u7093\uf3a2\u6919\u3d4e\ud7bb")), new Object[]{clazz, methodName, Arrays.toString(arguments)});
            return null;
        }
    }

    private static /* synthetic */ Constructor getConstructorLookupClass() {
        if (CONSTRUCTOR_LOOKUP_CLASS == null) {
            Class lookup = ReflectionUtils.lookupClass(ConfigChangedHandler.l(Cleaner$Cleaner.v("\u5570\u5700\ue0ba\u29cb\u103f\ud561\u9180\u88e8\u6621\u19e3\u6e47\ub77c\u6c6f\u48cc\uc64b\uf803\u5e28\u1eb8\u570c\ue92a\u198f\ud111\u789f\udd7f\udb0c\u2630\u2fa0\u9dde\u0428\uab25\u968f\ub2df\uf8e8\u2502\u9363\ud561\u9ab0")));
            CONSTRUCTOR_LOOKUP_CLASS = ReflectionUtils.lookupDeclaredConstructor(lookup, Class.class);
        }
        return CONSTRUCTOR_LOOKUP_CLASS;
    }

    static {
        LOG = Logger.getLogger(ReflectionUtils.class.getName());
        Class methodHandles = ReflectionUtils.lookupClass(CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d7f\u8792\u2de8\u3195\ucf23\u4693\u38cd\ued65\u9f52\uea21\u349f\u0c18\uf1fa\ue24f\u5493\u3dc5\u0db0\uf5e8\ucc70\ua664\u2b0b\u5392\u0715\u5f11\u5ac2\u72f1\uf9ca\uddd4\uc7ba\ua4ab")));
        Class methodHandle = ReflectionUtils.lookupClass(ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d53\u87c2\u2dc4\u31c5\ucf0f\u46c3\u38e1\ued35\u9f7e\uea71\u34b3\u0c48\uf1d6\ue21f\u54bf\u3d95\u0d9c\uf5b8\ucc5c\ua634\u2b27\u53c2\u0739\u5f41\u5aee\u72a1\uf9e6\udd84\uc796")));
        Class lookup = ReflectionUtils.lookupClass(CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d6f\u8782\u2df8\u3185\ucf33\u4683\u38dd\ued75\u9f42\uea31\u348f\u0c08\uf1ea\ue25f\u5483\u3dd5\u0da0\uf5f8\ucc60\ua674\u2b1b\u5382\u0705\u5f01\u5ad2\u72e1\uf9da\uddc4\uc7aa\ua4bb\u70f7\u5263\ub3fa\u1663\uf24e\u7d4d\uc767")));
        Class methodType = ReflectionUtils.lookupClass(ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d53\u87c2\u2dc4\u31c5\ucf0f\u46c3\u38e1\ued35\u9f7e\uea71\u34b3\u0c48\uf1d6\ue21f\u54bf\u3d95\u0d9c\uf5b8\ucc5c\ua634\u2b27\u53c2\u0739\u5f5d\u5af6\u72bf\uf9e7")));
        METHOD_IS_DEFAULT = ReflectionUtils.lookupMethod(Method.class, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d6c\u8790\u2dca\u3181\ucf7b\u468e\u38c9\ued77\u9f51")), new Class[0]);
        METHOD_HANDLES_LOOKUP = ReflectionUtils.lookupMethod(methodHandles, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d39\u87a0\u2db1\u31a3\ucf38\u46b3")), new Class[0]);
        METHOD_HANDLES_LOOKUP_IN = ReflectionUtils.lookupMethod(lookup, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d7c\u879d")), Class.class);
        METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL = ReflectionUtils.lookupMethod(lookup, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d20\u87a1\u2dac\u31ad\ucf2b\u46af\u3889\ued54\u9f01\uea60\u34c6\u0c2f\uf1af\ue275\u54d9\u3df0")), Method.class, Class.class);
        METHOD_HANDLES_LOOKUP_FIND_SPECIAL = ReflectionUtils.lookupMethod(lookup, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d63\u878a\u2de0\u3180\ucf4e\u469f\u38d9\ued78\u9f4c\uea7e\u348a")), Class.class, String.class, methodType, Class.class);
        METHOD_HANDLES_BIND_TO = ReflectionUtils.lookupMethod(methodHandle, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d37\u87a6\u2db0\u31ac\ucf19\u46ac")), Object.class);
        METHOD_HANDLES_INVOKE_WITH_ARGUMENTS = ReflectionUtils.lookupMethod(methodHandle, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d6c\u878d\u2df8\u318b\ucf76\u468a\u38eb\ued72\u9f51\uea77\u34a7\u0c14\uf1fb\ue245\u5485\u3dd5\u0de0\uf5c1\ucc76")), Object[].class);
        METHOD_HANDLES_PRIVATE_LOOKUP_IN = ReflectionUtils.lookupMethod(methodHandles, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u7d49\u87d1\u2ddb\u31d2\ucf40\u46db\u38e5\ued17\u9f76\uea30\u34b1\u0c53\uf1d0\ue239\u54ba")), Class.class, lookup);
        METHOD_TYPE = ReflectionUtils.lookupMethod(methodType, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u7d78\u8796\u2dea\u319c\ucf62\u469b\u38f8\ued72\u9f45\uea6a")), Class.class, Class[].class);
    }

    public static Object invokeDefaultMethod(Object target, Object methodHandle, Object ... args) throws Throwable {
        Object boundMethodHandle = METHOD_HANDLES_BIND_TO.invoke(methodHandle, target);
        return METHOD_HANDLES_INVOKE_WITH_ARGUMENTS.invoke(boundMethodHandle, new Object[]{args});
    }

    public static Object getMethodHandle(Method method) throws Exception {
        assert (ReflectionUtils.isDefault(method));
        Object baseLookup = ReflectionUtils.METHOD_HANDLES_LOOKUP.invoke(null, new Object[0]);
        try {
            Object lookup = ReflectionUtils.METHOD_HANDLES_PRIVATE_LOOKUP_IN.invoke(null, method.getDeclaringClass(), baseLookup);
            Object mh = ReflectionUtils.METHOD_HANDLES_LOOKUP_FIND_SPECIAL.invoke(lookup, method.getDeclaringClass(), method.getName(), ReflectionUtils.METHOD_TYPE.invoke(null, method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass());
            return mh;
        }
        catch (Exception ex) {
            Object lookup = ReflectionUtils.getConstructorLookupClass().newInstance(method.getDeclaringClass());
            Object mh = ReflectionUtils.mhViaUnreflectSpecial(lookup, method);
            return mh;
        }
    }

    private static /* synthetic */ Class lookupClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.FINE, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u0876\u8223\ud270\u7da5\u527a\ucb17\uc495\uc559\uf167\u5e28\u43dd\u5f25\ueab0\u8d69\u4f5b\u5602\ucdaf\ud557\u5116\u39c3\u1a36\ue0ed\ua48e\u675c")) + name, ex);
            return null;
        }
    }

    public static boolean isDefault(Method method) {
        if (METHOD_IS_DEFAULT == null) {
            return false;
        }
        try {
            return (Boolean)METHOD_IS_DEFAULT.invoke((Object)method, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static /* synthetic */ Object mhViaUnreflectSpecial(Object lookup, Method method) throws Exception {
        Object l2 = METHOD_HANDLES_LOOKUP_IN.invoke(lookup, method.getDeclaringClass());
        return METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL.invoke(l2, method, method.getDeclaringClass());
    }

    private static /* synthetic */ Constructor lookupDeclaredConstructor(Class clazz, Class ... arguments) {
        if (clazz == null) {
            LOG.log(Level.FINE, CallbackThreadInitializer.l(Cleaner$Cleaner.v("\u3032\u83b2\u0d75\u5897\uda58\ufc65\u0a80\u92b2\u39aa\uafdd\u0fa3\u9e0a\u2d23\uc2e2\u0d14\udef3\ubb67\ua4dd\u4dc3\u5533\u4219\ua5b0\u8f93\u5641\u8585\u4b25\uf536\ua5ae\u2a2c\u42a4\u902a\u804f\u623f\u00ed\uf696\ud701\ueaa1\u8815\u60cb\u1c01")), new Object[]{clazz, Arrays.toString(arguments)});
            return null;
        }
        try {
            Constructor init = clazz.getDeclaredConstructor(arguments);
            init.setAccessible(true);
            return init;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, ConfigChangedHandler.l(Cleaner$Cleaner.v("\u3072\u838e\u0d35\u58ab\uda18\ufc59\u0ac0\u928e\u39ea\uafe1\u0fe3\u9e36\u2d63\uc2de\u0d54\udecf\ubb27\ua4e1\u4d83\u550f\u4259\ua58c\u8fd3\u567d\u85c5\u4b19\uf576\ua592\u2a6c\u4298\u906a\u8073\u627f\u00d1\uf6d6\ud73d\ueae1\u8829\u608b\u1c3d")), new Object[]{clazz, Arrays.toString(arguments)});
            return null;
        }
    }
}

